/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.radar;

import com.atsuishio.superbwarfare.entity.vehicle.base.AirEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.HelicopterEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import tech.vvp.vvp.network.VVPNetwork;
import tech.vvp.vvp.network.message.S2CRadarSyncPacket;

public interface IRadarVehicle {
    public static final String RADAR_NBT_KEY = "vvp_radar_enabled";

    default public boolean isRadarEnabled() {
        Entity self = (Entity)this;
        return !self.getPersistentData().m_128441_(RADAR_NBT_KEY) || self.getPersistentData().m_128471_(RADAR_NBT_KEY);
    }

    default public void setRadarEnabled(boolean enabled) {
        ((Entity)this).getPersistentData().m_128379_(RADAR_NBT_KEY, enabled);
    }

    default public int getRadarRange() {
        return 150;
    }

    default public boolean isValidRadarTarget(Entity e) {
        return (e instanceof HelicopterEntity || e instanceof AirEntity) && e != this;
    }

    default public int getRadarEnergyCostPerScan() {
        return 35;
    }

    default public boolean consumeRadarEnergy() {
        return true;
    }

    default public void scanAndSendRadarTo(ServerPlayer player) {
        AABB box;
        if (!this.isRadarEnabled()) {
            return;
        }
        Entity self = (Entity)this;
        Level level = self.m_9236_();
        List potentialTargets = level.m_6249_(self, box = self.m_20191_().m_82400_((double)this.getRadarRange()), this::isValidRadarTarget);
        if (potentialTargets.isEmpty()) {
            return;
        }
        ArrayList<Vec3> pos = new ArrayList<Vec3>(potentialTargets.size());
        for (Entity target : potentialTargets) {
            pos.add(target.m_20182_());
        }
        VVPNetwork.VVP_HANDLER.sendTo((Object)new S2CRadarSyncPacket(pos), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

